@echo off
set "JAVA_OPTS=-Xms2048M -Xmx4096M -XX:MetaspaceSize=256M -XX:MaxMetaspaceSize=512M -XX:ReservedCodeCacheSize=512M"
set "JAVA_OPTS=%JAVA_OPTS% -Djava.net.preferIPv4Stack=true"
set "JAVA_OPTS=%JAVA_OPTS% -Dfile.encoding=UTF-8"
set "JAVA_OPTS=%JAVA_OPTS% -Djava.awt.headless=true -XX:CompressedClassSpaceSize=256M -Djboss.threads.eqe.statistics.active-count=true"

set "BUNDLE_HOME=%~dp0"
set "BUNDLE_HOME=%BUNDLE_HOME:~0,-1%"
pushd %BUNDLE_HOME%\..
set "PEC_HOME=%CD%"
popd
set "JAVA_HOME=%PEC_HOME%\jre\current"

set "CERTMGR_HOME=%BUNDLE_HOME%\certmgr"
set "CERTMGR_CONFIG_FILE=%CERTMGR_HOME%\config\ssl.properties"
if exist "%CERTMGR_CONFIG_FILE%" (
    set "SPRING_CONFIG_ADDITIONAL_LOCATION=%CERTMGR_CONFIG_FILE%"
    cd "%CERTMGR_HOME%"
    "%JAVA_HOME%\bin\java.exe" -jar "%CERTMGR_HOME%\certmgr.jar" --renew
)

cd "%BUNDLE_HOME%"
"%JAVA_HOME%\bin\java.exe" %JAVA_OPTS% -jar "%BUNDLE_HOME%\pec-bundle.jar"